/*
* MainForm.cs - Example program for PeLib.NET
*
* Copyright (c) 2005 Sebastian Porst (webmaster@the-interweb.com)
* All rights reserved.
*
* This software is licensed under the zlib/libpng License.
* For more details see http://www.opensource.org/licenses/zlib-license.php
* or the license information file (license.htm) in the root directory 
* of PeLib.
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace OffsNet
{
    public partial class MainForm : Form
    {
        private PeLibNet.PeFile32 pef = null;

        public MainForm()
        {
            InitializeComponent();
        }

        private void aboutToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            MessageBox.Show(this, "Sample program for PeLib.NET", "Offset converter", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
            {
                try
                {
                    pef = new PeLibNet.PeFile32(openFileDialog1.FileName);

                    if ((pef.MzHeader.IsValid() == PeLibNet.ValidCode.Valid)
                        && (pef.PeHeader.IsValid() == PeLibNet.ValidCode.Valid))
                    {
                        toolStripStatusLabel1.Text = "Current file: " + System.IO.Path.GetFileName(openFileDialog1.FileName);
                        toolStripStatusLabel1.ForeColor = Color.Green;
                    
                        textBox1.Enabled = textBox2.Enabled = textBox3.Enabled = true;
                        textBox1.Text = textBox2.Text = textBox3.Text = "";
                    }
                    else
                    {
                        toolStripStatusLabel1.Text = "Invalid PE file.";
                        toolStripStatusLabel1.ForeColor = Color.Red;

                        textBox1.Enabled = textBox2.Enabled = textBox3.Enabled = false;
                        textBox1.Text = textBox2.Text = textBox3.Text = "";
                    }
                }
                catch (PeLibNet.PeLibException)
                {
                    textBox1.Enabled = textBox2.Enabled = textBox3.Enabled = true;
                    textBox1.Text = textBox2.Text = textBox3.Text = "";

                    MessageBox.Show(this, "Error opening file.", "Offset converter", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void updateSectionTextBox(int rva)
        {
            int sectionNumber = pef.PeHeader.GetSectionWithRva(rva);

            textBox4.Text = sectionNumber == -1 ?
                "Not in any section" : pef.PeHeader.Sections[sectionNumber].Name;
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (ActiveControl != sender) return;

            try
            {
                int rva = Convert.ToInt32(textBox1.Text, 16);

                int va = pef.PeHeader.RvaToVa(rva);
                int offset = pef.PeHeader.RvaToOffset(rva);

                textBox2.Text = va == -1 ? "Invalid offset" : Convert.ToString(va, 16);
                textBox3.Text = offset == -1 ? "Invalid offset" : Convert.ToString(offset, 16);

                updateSectionTextBox(rva);
            }
            catch (Exception)
            {
                // Don't do anything when an invalid offset was handled.
            }
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            if (ActiveControl != sender) return;

            try
            {
                int va = Convert.ToInt32(textBox2.Text, 16);

                int rva = pef.PeHeader.VaToRva(va);
                int offset = pef.PeHeader.VaToOffset(va);

                textBox1.Text = rva == -1 ? "Invalid offset" : Convert.ToString(rva, 16);
                textBox3.Text = offset == -1 ? "Invalid offset" : Convert.ToString(offset, 16);

                updateSectionTextBox(rva);
            }
            catch (Exception)
            {
                // Don't do anything when an invalid offset was handled.
            }
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            if (ActiveControl != sender) return;

            try
            {
                int offset = Convert.ToInt32(textBox3.Text, 16);

                int rva = pef.PeHeader.OffsetToRva(offset);
                int va = pef.PeHeader.OffsetToVa(offset);

                textBox1.Text = rva == -1 ? "Invalid offset" : Convert.ToString(rva, 16);
                textBox2.Text = va == -1 ? "Invalid offset" : Convert.ToString(va, 16);

                updateSectionTextBox(rva);
            }
            catch (Exception)
            {
                // Don't do anything when an invalid offset was handled.
            }
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://www.pelib.com");
        }
    }
}