/*
* neshelp.cpp - Some helper functions for NES development.
*
* Copyright (c) 2005 Sebastian Porst (webmaster@the-interweb.com)
* All rights reserved.
*
* This software is licensed under the zlib/libpng License.
* For more details see http://www.opensource.org/licenses/zlib-license.php
*/

unsigned char makeMask(unsigned int bit, unsigned int length)
{
	unsigned char mask = 0;
	
	for (unsigned int i=0;i<length;i++)
	{
		mask |= 1 << (7 - (bit + i));
	}
	
	return mask;
}

unsigned char getBits(unsigned char byte, unsigned int bit, unsigned int length)
{
	if (length <= 0) return 0;
	
	return byte & makeMask(bit, length);
}

unsigned char getBits(unsigned char* data, unsigned int byte, unsigned int bit, unsigned int length)
{
	unsigned int len1 = length > 8 - bit ? 8 - bit : length;
	unsigned int len2 = length - len1;

	unsigned int bits1 = getBits(data[byte], bit, len1);
	unsigned int bits2 = getBits(data[byte + 1], 0, len2);

	if (len1 <= length) bits1 >>= (8 - (len1 + bit));
	if (len2 > 0) bits1 <<= len2;
	
	bits2 >>= 8 - len2;
	
	return bits1 | bits2;
}
