/*
* neshelp.h - Some helper functions for NES development.
*
* Copyright (c) 2005 Sebastian Porst (webmaster@the-interweb.com)
* All rights reserved.
*
* This software is licensed under the zlib/libpng License.
* For more details see http://www.opensource.org/licenses/zlib-license.php
*/

#ifndef NESHELP_H
#define NESHELP_H

unsigned char getBits(unsigned char* data, unsigned int byte, unsigned int bit, unsigned int length);
unsigned char getBits(unsigned char byte, unsigned int bit, unsigned int length);

template<unsigned int maxbuffersize>
class StuffBits
{
	private:
		unsigned int position;
		unsigned char buffer[maxbuffersize];
		unsigned char sum;
		
	public:
		StuffBits()
		{
			position = 0;
			sum = 0;
			for (unsigned int i=0;i<sizeof(buffer);i++) buffer[i] = 0;
		}
		
		void addBits(unsigned char bits, unsigned int size)
		{
			unsigned int bytepos = position / 8;
			unsigned int bitpos = position % 8;

			unsigned int len1 = std::min(size, 8 - bitpos);
			unsigned int len2 = bitpos + size < 8 ? 0 : size - len1;

			unsigned char data1 = getBits(bits, 8 - size, len1);
			data1 >>= size - len1;
			unsigned char data2 = getBits(bits, 8 - size + len1, len2);
			
			buffer[bytepos] |= (data1 << (8 - len1 - bitpos));
			buffer[bytepos + 1] = (data2 << (8 - len2));
			
			position += size;
			
			if (position / 8 != bytepos)
			{
				sum += buffer[bytepos];
			}
		}
		
		unsigned char* getBuffer()
		{
			return buffer;
		}
		
		unsigned int size() const
		{
			return position;
		}
};

#endif
